
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DAL
{
    internal class EvaluationSheet_Class : PI.FM.N000.Base.BL.DAL.BaseTable<DBD.EvaluationSheet_Class, BO.EvaluationSheet_Class>
    {

        internal EvaluationSheet_Class(Gemini.Core.BL.Interface.IBusinessLogicPlugIn BusinessLogicPlugIn) : this(BusinessLogicPlugIn.Environment, BusinessLogicPlugIn.DriverName) { }

        internal EvaluationSheet_Class(Gemini.Core.BL.Interface.DAL.IEnvironment Environment, string DriverName) : base(Environment, DriverName, DBD.EvaluationSheet_Class.DBD) { }

        internal List<BO.EvaluationSheet_Class> Restore(BO.EvaluationSheet_Class.Search Search)
        {
            return InternalRestoreList((int)DBD.EvaluationSheet_Class.Commands.RestoreBySearch,
                delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
                {
                    Command["EvaluationSheetID"].Value = Search.EvaluationSheetID;
                    Command["ClassID"].Value = Search.ClassID;
                });
        }

        internal bool Remove(BO.EvaluationSheet_Class.Search Search)
        {
            bool _return = false;
            Gemini.Core.BL.Interface.DBD.ICommand _command = InternalExecuteScalar((int)DBD.EvaluationSheet_Class.Commands.RemoveBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["EvaluationSheetID"].Value = Search.EvaluationSheetID;
                Command["ClassID"].Value = Search.ClassID;
                Command["EditDate"].Value = DateTime.Now;
                Command["EditUser"].Value = Environment.User.ID;
            });

            if (_command != null)
            {
                if (_command.ResultParam != null)
                {
                    _return = _command.ResultParamValue >= 0 ? true : false;
                }
                else
                {
                    _return = true;
                }
            }
            return _return;
        }
    }
}